﻿using System;
using System.Collections;
using System.Windows;
using System.Windows.Data;

namespace WPF.PresentationLayer.Converters
{
    public class EmptyListToBoolConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value == null) return false;
            var list = value as ICollection;

            if (list == null) return false;

            // *** Fortify Justified Code ***
            // *** can't be null since it is checked earler. ReSharper doesn't see an issues either ***
            return list.Count == 0 ? false : true;

            // *** Fortify Justified Code *** 

        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
